import { useContext, useRef } from 'react';
import { PresenceContext } from '../../context/PresenceContext.mjs';
import { useVisualElementContext } from '../../context/MotionContext/index.mjs';
import { useIsomorphicLayoutEffect } from '../../utils/use-isomorphic-effect.mjs';
import { LazyContext } from '../../context/LazyContext.mjs';
import { MotionConfigContext } from '../../context/MotionConfigContext.mjs';

function useVisualElement(Component, visualState, props, createVisualElement) {
    const parent = useVisualElementContext();
    const lazyContext = useContext(LazyContext);
    const presenceContext = useContext(PresenceContext);
    const reducedMotionConfig = useContext(MotionConfigContext).reducedMotion;
    const visualElementRef = useRef();
    /**
     * If we haven't preloaded a renderer, check to see if we have one lazy-loaded
     */
    createVisualElement = createVisualElement || lazyContext.renderer;
    if (!visualElementRef.current && createVisualElement) {
        visualElementRef.current = createVisualElement(Component, {
            visualState,
            parent,
            props,
            presenceId: presenceContext ? presenceContext.id : undefined,
            blockInitialAnimation: presenceContext
                ? presenceContext.initial === false
                : false,
            reducedMotionConfig,
        });
    }
    const visualElement = visualElementRef.current;
    useIsomorphicLayoutEffect(() => {
        visualElement && visualElement.render();
    });
    /**
     * If we have optimised appear animations to handoff from, trigger animateChanges
     * from a synchronous useLayoutEffect to ensure there's no flash of incorrectly
     * styled component in the event of a hydration error.
     */
    useIsomorphicLayoutEffect(() => {
        if (visualElement && visualElement.animationState) {
            visualElement.animationState.animateChanges();
        }
    });
    useIsomorphicLayoutEffect(() => () => visualElement && visualElement.notify("Unmount"), []);
    return visualElement;
}

export { useVisualElement };
